// File ini akan disuntikkan langsung ke halaman web

// Ambil data yang sudah disisipkan di dalam elemen script
const lat = parseFloat(document.currentScript.getAttribute('data-lat'));
const lon = parseFloat(document.currentScript.getAttribute('data-lon'));

if (!isNaN(lat) && !isNaN(lon)) {
  const RADIUS_METERS = 60;

  // --- Logika pengacakan lokasi ---
  const radiusInDegrees = RADIUS_METERS / 111320;
  const u = Math.random();
  const v = Math.random();
  const w = radiusInDegrees * Math.sqrt(u);
  const t = 2 * Math.PI * v;
  const x = w * Math.cos(t);
  const y = w * Math.sin(t);
  const new_x = x / Math.cos(lat * Math.PI / 180);

  const fakeLatitude = lat + y;
  const fakeLongitude = lon + new_x;

  // Timpa fungsi geolocation
  navigator.geolocation.getCurrentPosition = function(successCallback, errorCallback, options) {
    const position = {
      coords: {
        latitude: fakeLatitude,
        longitude: fakeLongitude,
        accuracy: Math.random() * 10 + 10,
        altitude: null,
        altitudeAccuracy: null,
        heading: null,
        speed: null,
      },
      timestamp: Date.now(),
    };
    console.log("Geolocation faked (otomatis):", position);
    successCallback(position);
  };

  navigator.geolocation.watchPosition = function(successCallback, errorCallback, options) {
    setInterval(() => {
      navigator.geolocation.getCurrentPosition(successCallback, errorCallback, options);
    }, 1000);
    return 1;
  };
}