// Tombol 1: Hanya mengisi halaman, tanpa klik 'Next'
document.getElementById('stepButton').addEventListener('click', () => {
  chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
    chrome.tabs.sendMessage(tabs[0].id, { action: "fillStepOnly" });
  });
});

// Tombol 2: BARU -> Memulai mode PENGULANGAN 'Isi & Next' setiap 0.3 detik
document.getElementById('stepAndNextButton').addEventListener('click', () => {
  chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
    // Kirim perintah untuk MEMULAI pengulangan
    chrome.tabs.sendMessage(tabs[0].id, { action: "startRepeating" });
  });
});

// Tombol 3: Memulai mode SANGAT AGRESIF (Otomatis penuh)
document.getElementById('superAggressiveButton').addEventListener('click', () => {
  chrome.storage.session.set({ isSuperAggressive: true }, () => {
    chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
      chrome.tabs.sendMessage(tabs[0].id, { action: "startSuperAggressive" });
    });
  });
});

// Tombol Berhenti: SEKARANG bisa menghentikan SEMUA mode otomatis
document.getElementById('stopButton').addEventListener('click', () => {
  // Matikan flag mode super agresif
  chrome.storage.session.set({ isSuperAggressive: false }, () => {
    console.log("Flag Super Agresif dinonaktifkan.");
  });
  // Kirim perintah untuk MENGHENTIKAN semua aksi berulang
  chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
    chrome.tabs.sendMessage(tabs[0].id, { action: "stopAllActions" });
  });
  window.close();
});